/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.CompStatusDefault;
import ibm.nways.jdm.CompoundStatus;
import ibm.nways.jdm.CompoundStatusProxy;
import ibm.nways.jdm.FolderStatusDestination;
import ibm.nways.jdm.I18NStringTranslated;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolderListener;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.RemoteCompoundStatus;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.RemoteModelWithStatus;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.StatusProxy;
import java.util.Enumeration;
import java.util.Vector;

public class NavigationFolder
extends NavigationPoint {
    private Vector contents = new Vector();
    private Vector listeners;
    private Status status;
    private boolean hasRemoteStatus;
    private boolean isInitiallyExpanded = true;

    public NavigationFolder() {
        this("");
    }

    public NavigationFolder(String string) {
        this(string, null, null);
    }

    public NavigationFolder(String string, NavigationDestination navigationDestination) {
        this(string, navigationDestination, null);
    }

    public NavigationFolder(String string, String string2) {
        this(string, null, string2);
    }

    public NavigationFolder(String string, NavigationDestination navigationDestination, String string2) {
        super(string, navigationDestination, string2);
    }

    public void setDestination(NavigationDestination navigationDestination) {
        if (navigationDestination == null) {
            navigationDestination = new FolderStatusDestination(this);
        }
        super.setDestination(navigationDestination);
        RemoteModel remoteModel = this.getDestination().getModel();
        RemoteStatus remoteStatus = null;
        if (remoteModel != null && remoteModel instanceof RemoteModelWithStatus) {
            try {
                remoteStatus = ((RemoteModelWithStatus)remoteModel).getStatus();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                remoteStatus = null;
            }
        }
        if (remoteStatus != null) {
            this.hasRemoteStatus = true;
            if (remoteStatus instanceof RemoteCompoundStatus) {
                this.status = new CompoundStatusProxy((RemoteCompoundStatus)remoteStatus);
                return;
            }
            this.status = new StatusProxy(remoteStatus);
            return;
        }
        this.hasRemoteStatus = false;
        this.status = new CompoundStatus();
        this.status.setName(new I18NStringTranslated(this.getLabel()));
        ((CompoundStatus)this.status).setManager(new CompStatusDefault());
        if (this.contents != null) {
            Enumeration enumeration = this.contents.elements();
            while (enumeration.hasMoreElements()) {
                NavigationPoint navigationPoint = (NavigationPoint)enumeration.nextElement();
                Status status = navigationPoint.getStatus();
                if (status == null) continue;
                ((CompoundStatus)this.status).addDependent(status);
            }
        }
    }

    public void addListener(NavigationFolderListener navigationFolderListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(navigationFolderListener)) {
            this.listeners.addElement(navigationFolderListener);
        }
    }

    public void removeListener(NavigationFolderListener navigationFolderListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(navigationFolderListener);
    }

    public boolean getIsInitiallyExpanded() {
        return this.isInitiallyExpanded;
    }

    public void setIsInitiallyExpanded(boolean bl) {
        this.isInitiallyExpanded = bl;
    }

    public Enumeration getContents() {
        return this.contents.elements();
    }

    public void add(NavigationPoint navigationPoint) {
        Status status = navigationPoint.getStatus();
        if (status != null && !this.hasRemoteStatus) {
            ((CompoundStatus)this.status).addDependent(status);
        }
        this.contents.addElement(navigationPoint);
        navigationPoint.setParent(this);
        this.fireAddEvent(this, navigationPoint);
    }

    private boolean fireAddEvent(NavigationFolder navigationFolder, NavigationPoint navigationPoint) {
        Object object;
        boolean bl = false;
        if (this.listeners != null) {
            object = this.listeners.elements();
            while (object.hasMoreElements() && !bl) {
                bl = ((NavigationFolderListener)object.nextElement()).addNavigationFolderChild(navigationFolder, navigationPoint);
            }
        }
        if (!bl && (object = (NavigationFolder)this.getParent()) != null) {
            bl = super.fireAddEvent(navigationFolder, navigationPoint);
        }
        return bl;
    }

    private boolean fireRemoveEvent(NavigationFolder navigationFolder, NavigationPoint navigationPoint) {
        Object object;
        boolean bl = false;
        if (this.listeners != null) {
            object = this.listeners.elements();
            while (object.hasMoreElements() && !bl) {
                bl = ((NavigationFolderListener)object.nextElement()).removeNavigationFolderChild(navigationFolder, navigationPoint);
            }
        }
        if (!bl && (object = (NavigationFolder)this.getParent()) != null) {
            bl = super.fireAddEvent(navigationFolder, navigationPoint);
        }
        return bl;
    }

    public Status getStatus() {
        return this.status;
    }

    public NavigationPoint findId(String string) {
        NavigationPoint navigationPoint = super.findId(string);
        if (navigationPoint != null) {
            return navigationPoint;
        }
        Enumeration enumeration = this.contents.elements();
        while (enumeration.hasMoreElements()) {
            navigationPoint = ((NavigationPoint)enumeration.nextElement()).findId(string);
            if (navigationPoint != null) break;
        }
        return navigationPoint;
    }

    public void removeChild(NavigationPoint navigationPoint) {
        super.removeChild(navigationPoint);
        Status status = navigationPoint.getStatus();
        if (!this.hasRemoteStatus && status != null) {
            ((CompoundStatus)this.status).removeDependent(status);
        }
        this.contents.removeElement(navigationPoint);
        this.fireRemoveEvent(this, navigationPoint);
    }

    public void dispose() {
        if (this.listeners != null) {
            this.listeners.removeAllElements();
        }
        if (this.contents != null) {
            Enumeration enumeration = this.contents.elements();
            while (enumeration.hasMoreElements()) {
                ((NavigationPoint)enumeration.nextElement()).dispose();
            }
            this.contents.removeAllElements();
        }
        this.listeners = null;
        this.contents = null;
        if (this.status != null) {
            if (this.status instanceof StatusProxy) {
                ((StatusProxy)this.status).dispose();
            }
            this.status = null;
        }
        super.dispose();
    }
}

